package gov.va.med.mhv.integration.phr.service.vistaweb.cache;

import java.util.Date;
import java.util.Hashtable;

public class CacheEntry {
	private String outboundId;
	private String inboundId;
	private long crc32;
	private Hashtable<String,Long> facilityInfo;
	private Hashtable<String,Long> phrFacilitycontrol;
	private Hashtable<String,Date> chemHistMap;
	private String icn;
	private Long patientId;
	
	static final private Hashtable<String,Long> emptyFacilityInfo = new Hashtable<String,Long>();
	static final private Hashtable<String,Long> emptyPhrFacilityControl = new Hashtable<String,Long>();
	static final private Hashtable<String,Date> emptyChemHistMap = new Hashtable<String,Date>();

	public CacheEntry() {
	}
	
	public String getInboundId() {
		return inboundId;
	}
	public void setInboundId(String id) {
		this.inboundId = id;
	}
	public long getCrc32() {
		return crc32;
	}
	public void setCrc32(long crc32) {
		this.crc32 = crc32;
	}
	public void setOutboundId(String outboundId) {
		this.outboundId = outboundId;
	}
	public String getOutboundId() {
		return outboundId;
	}
	public String toString(){ 
		return "CacheEntry {inboundId="+inboundId+";outboundId="+outboundId+"; crc32=" + crc32+"}";
	}
	public boolean verifyIds() {
		if( inboundId.equalsIgnoreCase(outboundId)) return true;
		return false;
	}
	
	public Hashtable<String, Long> getFacilityInfo(String icn) {
		if(this.icn.equalsIgnoreCase(icn))
			return facilityInfo;
		else
			return emptyFacilityInfo;
	}

	public void setFacilityInfo(Hashtable<String, Long> facilityInfo) {
		this.facilityInfo = facilityInfo;
	}

	public Hashtable<String, Long> getPhrfacilitycontrol(String icn) {
		if(this.icn.equalsIgnoreCase(icn))
			return this.phrFacilitycontrol;
		else
			return emptyPhrFacilityControl;
	}

	public void setPhrfacilitycontrol(Hashtable<String, Long> phrfacilitycontrol) {
		this.phrFacilitycontrol = phrfacilitycontrol;
	}

	public String getIcn() {
		return icn;
	}

	public void setIcn(String icn) {
		this.icn = icn;
	}

	public Long getPatientId( String icn ) {
		if(this.icn.equalsIgnoreCase(icn))
			return this.patientId;
		else
			return null;
	}
	
	public void setPatientId( Long patientId ) {
		this.patientId = patientId;
	}
	
	/**
	 * If either current or new crc32 are 0 then isCurrent is false
	 * 
	 * @param currentCrc32
	 * @return
	 */
	public boolean isCurrentData(long currentCrc32) {
		return (currentCrc32==crc32) && currentCrc32 != 0 && crc32 != 0;
	}

	public void setChemistryHistory(Hashtable<String, Date> chemHistMap) {
		this.chemHistMap = chemHistMap;
	}
	
	public Hashtable<String, Date> getChemistryHistory(String icn) {
		if(this.icn.equalsIgnoreCase(icn))
			return this.chemHistMap;
		else
			return emptyChemHistMap;
	}
	
}
